#include <arduino.h>

#define	BUFSIZE	64		// 移動平均バッファサイズ
#define	MON		D13		// led
#define	PUSW	D12		// push switch
#define	LEDDIR1	D2		// LED direction 0:LEFT
#define	LEDDIR2	D3		// LED direction 0:RIGHT
#define	AMBHIGH	100		// 周囲光Highのしきい値（固定値）
#define	HOUR23	50400	// 23時(UTC)
#define	HOUR27	64800	// 03時(UTC)
#define	SECOND1	1000	// 1s

#define	NTPACS	21600	// NTPアクセス間隔:6時間

#define	LIM1	600		// 30s
#define	LIM2	600		// 30s
#define	LIM3	600		// 30s
#define	LIM4	40		// 2s
#define	LIM5	40		// 2s
#define	LIM6	40		// 2s
#define	LIM7	400		// 20s
#define	LIM8	100		// 5s
#define	LIM99	3		// 150ms
#define	BLINKMAX	10

// LED buffer [32bitでaddr,R,G,B,BRを使い分ける]
typedef union {
	uint32_t	d32;
	uint8_t		d8[4];		// リトルエンディアン
	struct {
		uint8_t BR;			// 輝度(0-127)
		union {
			struct {		// 5byte RGB数値設定モード(主にデバッグ用)用
				uint8_t R;	// R(0-127)
				uint8_t G;	// G(0-127)
				uint8_t B;	// B(0-127)
			};
			struct {		// 3byte カラーNo選択モード(ノーマルショート通信)用
				uint8_t COL;// プリセットカラー選択コード
				uint8_t DMY0;
				uint8_t DMY1;
			};
		};
	};
} dt4byte;
